package gov.va.med.mhv.health.model;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="MILITARY_HEALTH_HISTORIES")

public class MilitaryHistory implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = -1112634400399571247L;

	@Id
	@Column(name = "MILITARY_HEALTH_ID_SEQ")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long id;
	
	@Column(name = "EVENT_TITLE")
	private String eventTitle="";
	
	@Column(name="EVENT_DATE") 
	@Temporal(TemporalType.DATE)
	private Date eventDate;
	
	@Column(name="SERVICE_BRANCH")
	private String serviceBranch="";
	
	@Column(name="SERVICE_RANK")
	private String rank="";
	
	@Column(name="SERVICE_LOCATION")
	private String serviceLocation="";
	
	@Column(name="ABOARD_SHIP")
	private String aboardShip="";
	
	@Column(name="MILITARY_OCCUPATION_SPECIALTY")
	private String occupationSpecialty="";
	
	@Column(name="SERVICE_ASSIGNMENT")
	private String serviceAssignment="";
	
	@Column(name="OCCUPATIONAL_EXPOSURES")
	private String exposures="";
	
	@Column(name="MILITARY_SERVICE_EXPERIENCE")
	private String experience="";
	
	@Column(name="OPLOCK")
	private Integer oplock=0;
	
	@Column(name="USER_PROFILE_USER_PROFILE_ID")
	private Long userprofileId;
	

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getEventTitle() {
		return eventTitle;
	}

	public void setEventTitle(String eventTitle) {
		if(eventTitle!=null) {
			this.eventTitle = eventTitle;
		}
	}

	public Date getEventDate() {
		return eventDate;
	}

	public void setEventDate(Date eventDate) {
		this.eventDate = eventDate;
	}

	public String getServiceBranch() {
		return serviceBranch;
	}

	public void setServiceBranch(String serviceBranch) {
		if(serviceBranch!=null) {
			this.serviceBranch = serviceBranch;
		}
	}

	public String getRank() {
		return rank;
	}

	public void setRank(String rank) {
		if(rank!=null) {
			this.rank = rank;
		}
	}

	public String getServiceLocation() {
		return serviceLocation;
	}

	public void setServiceLocation(String serviceLocation) {
		if(serviceLocation!=null) {
			this.serviceLocation = serviceLocation;
		}
	}

	public String getAboardShip() {
		return aboardShip;
	}

	public void setAboardShip(String aboardShip) {
		if(aboardShip!=null) {
			this.aboardShip = aboardShip;
		}
	}

	public String getOccupationSpecialty() {
		return occupationSpecialty;
	}

	public void setOccupationSpecialty(String occupationSpecialty) {
		if(occupationSpecialty!=null) {
			this.occupationSpecialty = occupationSpecialty;
		}
	}

	public String getServiceAssignment() {
		return serviceAssignment;
	}

	public void setServiceAssignment(String serviceAssignment) {
		if(serviceAssignment!=null) {
			this.serviceAssignment = serviceAssignment;
		}
	}

	public String getExposures() {
		return exposures;
	}

	public void setExposures(String exposures) {
		if(exposures!=null) {
			this.exposures = exposures;
		}
	}

	public String getExperience() {
		return experience;
	}

	public void setExperience(String experience) {
		if(experience!=null) {
			this.experience = experience;
		}
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public Long getUserprofileId() {
		return userprofileId;
	}

	public void setUserprofileId(Long userprofileId) {
		this.userprofileId = userprofileId;
	}
	

}
